#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_BloodUnitInactivate : BaseTest 
	{
		private	System.Guid _bloodUnitGuid;
		private DataTable _dtBloodUnit;

		
		private string _baseQuery = string.Concat(	"SELECT TOP 1 BU.* FROM BloodUnit BU ",
			"JOIN BloodUnitStatus BUS ON BU.BloodUnitGuid = BUS.BloodUnitGuid ",
			"JOIN BloodUnitStatusCodeCurrent BUSCC ON BU.BloodUnitGuid = BUSCC.BloodUnitGuid ",
			"WHERE BUSCC.UnitStatusCode = 'X' AND BU.BloodUnitGuid = BUS.BloodUnitGuid ",
			"AND BU.DivisionCode = '", UnitTestConfig.TestDivisionCode, "'" );
		
		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{ 
				this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable(_baseQuery, true);

				this._bloodUnitGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];

				this.RefreshData = false;
			}
		}

		[Test]
		public void InactivateUnit_4Tables_Pass()
		{
			System.Guid [] bloodUnitGuids = 
				{
					this._bloodUnitGuid
				};

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitAntigenPhenotypingSingleTestPhase);
			DataTable dtWorkloadEvent = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.UnitAntigenPhenotypingSingleTestPhase, bloodUnitGuids, Common.WorkloadTransactionType.Unit, true);

			// Added 12/8/2004 RDH
			BOL.BloodUnit bloodUnit=new BOL.BloodUnit(this._bloodUnitGuid);
			DataTable dtBloodUnit = DAL.BloodUnit.GetEmptyBloodUnitTableSchema(true);
			dtBloodUnit.Rows.Add(bloodUnit.LoadDataRowFromThis(dtBloodUnit.NewRow()));
			DataTable dtBloodUnitMedia = DAL.BloodUnitMedia.GetEmptyBloodUnitMediaTableSchema(true);
			dtBloodUnitMedia.Rows.Add(bloodUnit.BloodUnitMedia.LoadDataRowFromThis(dtBloodUnitMedia.NewRow()));

			//2899
			DataTable dtBloodUnitAntigen = SprocHelper.GetInactivateBloodUnitAntigenSprocTable(DAL.BloodUnitAntigen.GetBloodUnitAntigens(bloodUnit.BloodUnitGuid.ToString(), bloodUnit.DivisionCode), bloodUnit);
			

			Common.Utility.AppendLastUpdateInformation(dtBloodUnit, Common.UpdateFunction.UnitTests);
			Common.Utility.AppendLastUpdateInformation(dtBloodUnitMedia, Common.UpdateFunction.UnitTests);
			Common.Utility.AppendLastUpdateInformation(dtWorkloadEvent, Common.UpdateFunction.UnitTests);

			bool retValue = DAL.BloodUnitInactivate.InactivateUnit(dtBloodUnit, dtBloodUnitMedia, dtBloodUnitAntigen, dtWorkloadEvent);
			
			// If it makes it to the next line, no exception = it worked
			Assert.AreEqual(true, retValue, "ReturnValue");

			// CleanUP our data change-- reAcivate the Unit
			this.ReactivateUnit();
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(Common.RowVersionException))]
		public void InactivateUnit_4Tables_Fail()
		{
			System.Guid [] bloodUnitGuids = 
				{
					this._bloodUnitGuid
				};

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitAntigenPhenotypingSingleTestPhase);
			DataTable dtWorkloadEvent = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.UnitAntigenPhenotypingSingleTestPhase, bloodUnitGuids, Common.WorkloadTransactionType.Unit, true);

			// Added 12/8/2004 RDH
			BOL.BloodUnit bloodUnit=new BOL.BloodUnit(this._bloodUnitGuid);
			DataTable dtBloodUnit = DAL.BloodUnit.GetEmptyBloodUnitTableSchema(true);
			dtBloodUnit.Rows.Add(bloodUnit.LoadDataRowFromThis(dtBloodUnit.NewRow()));
			DataTable dtBloodUnitMedia = DAL.BloodUnitMedia.GetEmptyBloodUnitMediaTableSchema(true);
			dtBloodUnitMedia.Rows.Add(bloodUnit.BloodUnitMedia.LoadDataRowFromThis(dtBloodUnitMedia.NewRow()));

			dtBloodUnit.Rows[0][TABLES.BloodUnit.RowVersion] = new byte[8];
			dtBloodUnitMedia.Rows[0][TABLES.BloodUnitMedia.RowVersion] = new byte[8];

			Common.Utility.AppendLastUpdateInformation(dtBloodUnit, Common.UpdateFunction.UnitTests);
			Common.Utility.AppendLastUpdateInformation(dtBloodUnitMedia, Common.UpdateFunction.UnitTests);
			Common.Utility.AppendLastUpdateInformation(dtWorkloadEvent, Common.UpdateFunction.UnitTests);

			DataTable dtBloodUnitAntigen=SprocHelper.GetInactivateBloodUnitAntigenSprocTable(DAL.BloodUnitAntigen.GetBloodUnitAntigens(bloodUnit.BloodUnitGuid.ToString(), bloodUnit.DivisionCode), bloodUnit); //2899

			DAL.BloodUnitInactivate.InactivateUnit(dtBloodUnit, dtBloodUnitMedia, dtBloodUnitAntigen, dtWorkloadEvent);
		}

		[Test]
		public void InactivateUnit_5Tables_Pass()
		{
			this.RefreshData = true;

			System.Guid unitGuid = System.Guid.NewGuid();
			System.Guid bpGuid = DataCreator.GetRandomBloodProduct(true, Common.ComponentClass.ConversionClass).BloodProductGuid;
			DataCreator.CreateBloodUnit(unitGuid, System.Guid.NewGuid(), System.Guid.Empty, bpGuid, true);

			BOL.BloodUnit tmpUnit = new BOL.BloodUnit(unitGuid);

			System.Guid[] unitGuids = {unitGuid};

			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitShipment WHERE IncomingShipmentGuid = '" + tmpUnit.IncomingShipment.ShipmentGuid.ToString() + "'");
			System.Guid unitShipmentGuid = (System.Guid)dtTemp.Rows[0][TABLES.BloodUnitShipment.BloodUnitShipmentGuid];
			byte[] shipmentRowVersion = (byte[])dtTemp.Rows[0][TABLES.BloodUnitShipment.RowVersion];

			DataTable dtBU = DAL.BloodUnit.GetEmptyBloodUnitTableSchema(true);
			DataTable dtBUM = DAL.BloodUnitMedia.GetEmptyBloodUnitMediaTableSchema(true);
			DataTable dtIBUA = SprocHelper.GetInactivateBloodUnitAntigenSprocTable(DAL.BloodUnitAntigen.GetBloodUnitAntigens(tmpUnit.BloodUnitGuid.ToString(), tmpUnit.DivisionCode), tmpUnit);
			DataTable dtIBUS = SprocHelper.GetInactivateBloodUnitShipmentSprocTable(unitShipmentGuid, shipmentRowVersion);

			dtBU.Rows.Add(tmpUnit.LoadDataRowFromThis(dtBU.NewRow()));
			dtBUM.Rows.Add(tmpUnit.BloodUnitMedia.LoadDataRowFromThis(dtBUM.NewRow()));

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitLogin);
			DataTable dtWL = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.UnitLogin, unitGuids, Common.WorkloadTransactionType.Unit, true);

			Common.Utility.AppendLastUpdateInformation(dtBU, Common.UpdateFunction.UnitTests);
			Common.Utility.AppendLastUpdateInformation(dtBUM, Common.UpdateFunction.UnitTests);
			Common.Utility.AppendLastUpdateInformation(dtWL, Common.UpdateFunction.UnitTests);

			bool retValue = DAL.BloodUnitInactivate.InactivateUnit(dtBU, dtBUM, dtIBUA, dtIBUS, dtWL);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(Common.RowVersionException))]
		public void InactivateUnit_5Tables_Fail()
		{
			this.RefreshData = true;

			System.Guid unitGuid = System.Guid.NewGuid();
			System.Guid bpGuid = DataCreator.GetRandomBloodProduct(true, Common.ComponentClass.ConversionClass).BloodProductGuid;
			DataCreator.CreateBloodUnit(unitGuid, System.Guid.NewGuid(), System.Guid.Empty, bpGuid, true);

			BOL.BloodUnit tmpUnit = new BOL.BloodUnit(unitGuid);

			System.Guid[] unitGuids = {unitGuid};

			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitShipment WHERE IncomingShipmentGuid = '" + tmpUnit.IncomingShipment.ShipmentGuid.ToString() + "'");
			System.Guid unitShipmentGuid = (System.Guid)dtTemp.Rows[0][TABLES.BloodUnitShipment.BloodUnitShipmentGuid];
			byte[] shipmentRowVersion = (byte[])dtTemp.Rows[0][TABLES.BloodUnitShipment.RowVersion];

			DataTable dtBU = DAL.BloodUnit.GetEmptyBloodUnitTableSchema(true);
			DataTable dtBUM = DAL.BloodUnitMedia.GetEmptyBloodUnitMediaTableSchema(true);
			DataTable dtIBUA = SprocHelper.GetInactivateBloodUnitAntigenSprocTable(DAL.BloodUnitAntigen.GetBloodUnitAntigens(tmpUnit.BloodUnitGuid.ToString(), tmpUnit.DivisionCode), tmpUnit); //2899
			DataTable dtIBUS = SprocHelper.GetInactivateBloodUnitShipmentSprocTable(unitShipmentGuid, shipmentRowVersion);

			dtBU.Rows.Add(tmpUnit.LoadDataRowFromThis(dtBU.NewRow()));
			dtBUM.Rows.Add(tmpUnit.LoadDataRowFromThis(dtBUM.NewRow()));

			dtBU.Rows[0][TABLES.BloodUnit.RowVersion] = new byte[8];
			dtBUM.Rows[0][TABLES.BloodUnitMedia.RowVersion] = new byte[8];

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitLogin);
			DataTable dtWL = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.UnitLogin, unitGuids, Common.WorkloadTransactionType.Unit, true);
			
			Common.Utility.AppendLastUpdateInformation(dtBU, Common.UpdateFunction.UnitTests);
			Common.Utility.AppendLastUpdateInformation(dtBUM, Common.UpdateFunction.UnitTests);
			Common.Utility.AppendLastUpdateInformation(dtWL, Common.UpdateFunction.UnitTests);

			DAL.BloodUnitInactivate.InactivateUnit(dtBU, dtBUM, dtIBUA, dtIBUS, dtWL);

		}


		//**********Should this go in TearDown?
		private void ReactivateUnit()
		{
			int intRC1 = UnitTestUtil.RunSQL("UPDATE BloodUnit SET RecordStatusCode = 'A' WHERE BloodUnitGuid = '" + this._bloodUnitGuid.ToString() + "'");
			Assert.AreEqual(true, intRC1 > 0, "Reset Data1:");

            int intRC2 = UnitTestUtil.RunSQL("UPDATE BloodUnitMedia SET LastUpdateDate = GETUTCDATE(), Comments = null WHERE BloodUnitGuid = '" + this._bloodUnitGuid.ToString() + "'");
			Assert.AreEqual(true, intRC2 > 0, "Reset Data2:");

			int intRC3 = UnitTestUtil.RunSQL("UPDATE BloodUnitAntigen SET RecordStatusCode = 'A' WHERE BloodUnitGuid = '" + this._bloodUnitGuid.ToString() + "'");
			Assert.AreEqual(true, intRC3 >=0, "Reset Data3:");
		}

	}
}
#endif
